<?php

function create_hash ($inText, $saltHash=NULL)
{
  // hash the text //
  $textHash = hash ('md4', $inText);

  // set where salt will appear in hash //
  $saltStart = strlen ($inText);

  // add salt into text hash at pass length position and hash it //
  if ($saltStart > 0 && $saltStart < strlen ($saltHash))
  {
    $textHashStart = substr ($textHash, 0, $saltStart);

    $textHashEnd = substr ($textHash, $saltStart, strlen ($saltHash));

    $outHash = hash ('md4', $textHashEnd.$saltHash.$textHashStart);
  }
  elseif ($saltStart > (strlen ($saltHash) - 1))
  {
    $outHash = hash ('md4', $textHash.$saltHash);
  }
  else
  {
    $outHash = hash ('md4', $saltHash.$textHash);
  }

  return $outHash;
}

$skip  = $argv[1];
$limit = $argv[2];

$hashlist_l = array();
$hashlist_h = array();

$fp = fopen('l.hash', 'r');

while (! feof ($fp))
{
  $hash = trim (fgets ($fp));

  $hashlist_l[$hash] = 1;
}

fclose ($fp);

$fp = fopen('h.hash', 'r');

while (! feof ($fp))
{
  $hash = trim (fgets ($fp));

  $hashlist_h[$hash] = 1;
}

fclose ($fp);

$count = 0;
$found = 0;

printf ("skip = %ld, limit = %ld\n\n", $skip, $limit);


$starttime = microtime (true);

for ($seed = $skip; $seed < $limit; $seed++)
{
  mt_srand ($seed);

  $result_l  = 1;
  $result_l *= mt_rand();
  $result_l *= mt_rand();
  $result_l *= mt_rand();

  $hash_l = create_hash ($result_l, 'hashrunner2014l');

  if (isset ($hashlist_l[$hash_l]))
  {
    $fp = fopen ('l.seed', 'a');

    fprintf ($fp, "%ld\n", $seed);

    fclose ($fp);

    $found++;
  }

  mt_srand ($seed);

  $result_h  = '';
  $result_h .= mt_rand();
  $result_h .= mt_rand();
  $result_h .= mt_rand();

  $hash_h = create_hash ($result_h, 'hashrunner2014h');

  if (isset ($hashlist_h[$hash_h]))
  {
    $fp = fopen ('h.seed', 'a');

    fprintf ($fp, "%ld\n", $seed);

    fclose ($fp);

    $found++;
  }

  $count++;

  if ($count % 100000 == 0)
  {
    fprintf (STDERR, "%ld found  %ld c/s  %ld attempts in %ld seconds -- %0.2f%%\r", $found, $count / (microtime(true) - $starttime), $count, microtime(true) - $starttime, ($count / ($limit - $skip)) * 100);
  }
}

?>
