<?php


function hash_step($password, $salt, $mode, $username)
{
    global $algos, $local_salt, $helpers;

    $mode = intval($mode);
    if (array_key_exists($mode, $algos))
    {
        $hash = hash($algos[$mode], $password, True);
    } elseif (array_key_exists($mode - 10, $algos))
    {
        $hash = hash_hmac($algos[$mode - 10], $password, $salt);
    } elseif (array_key_exists($mode - 20, $algos))
    {
        return "HMAC";
        $hash = hash_hmac($algos[$mode - 20], $password, $local_salt);
    } elseif (array_key_exists($mode, $helpers))
    {
        $tmp = strval($helpers[$mode]);
        $hash = $tmp($password);
    }
    return $hash;
}

function do_hash($password, $salt, $mode, $username)
{
    $modes = explode(',', $mode);

    $hash = $password;
    foreach ($modes as $one)
    {
        $hash = hash_step($hash, $salt, $one, $username);
        if ($hash == "HMAC")
        {
          return;
        }
    }
#    echo $username."\n";

    return md5($hash);
}

function get_real_rand()
{
    if(function_exists('openssl_random_pseudo_bytes'))
        $a = abs(hexdec(bin2hex(openssl_random_pseudo_bytes(4))) & 0xFFFFFFFF);
    else
        $a = mt_rand();
    return $a;
}

function gen_modes($steps=4)
{
    $possibilities = array_merge(range(0, 7), range(10, 17), range(20, 27), range(100,103));
    $result = array();
    for ($i=0; $i < $steps; ++$i)
    {
        $result[] = $possibilities[get_real_rand() % count($possibilities)];
    }
    return implode(',', $result);
}

function gen_salt($length=16)
{
    $possibilities = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $result = array();
    for ($i=0; $i < $length; ++$i)
    {
        $result[] = $possibilities[get_real_rand() % strlen($possibilities)];
    }
    return implode('', $result);
}

function str_double($data)
{
    return $data.$data;
}
