
#define GPU
#include "md5.h"

__kernel void __attribute__((reqd_work_group_size (64, 1, 1))) md5stress (const __global block_t *blocks, const __global digest_t *digests, __global int *results)
{
  const int gid = get_global_id (0);
  const int lid = get_local_id (0);

  uint8 pw[16];

  pw[ 0] = (uint8) (blocks[gid].buf[0]);
  pw[ 1] = (uint8) (blocks[gid].buf[1]);
  pw[ 2] = (uint8) (blocks[gid].buf[2]);
  pw[ 3] = (uint8) (blocks[gid].buf[3]);
  pw[ 4] = (uint8) (0x80);
  pw[ 5] = (uint8) (0);
  pw[ 6] = (uint8) (0);
  pw[ 7] = (uint8) (0);
  pw[ 8] = (uint8) (0);
  pw[ 9] = (uint8) (0);
  pw[10] = (uint8) (0);
  pw[11] = (uint8) (0);
  pw[12] = (uint8) (0);
  pw[13] = (uint8) (0);
  pw[14] = (uint8) (16 * 8);
  pw[15] = (uint8) (0);

  const uint4 search = (uint4) (digests[gid].buf[0], digests[gid].buf[1], digests[gid].buf[2], digests[gid].buf[3]);

  for (int i = 0; i < 1024; i++)
  {
    uint8 digest[4];

    digest[0] = (uint8) (MAGIC_A);
    digest[1] = (uint8) (MAGIC_B);
    digest[2] = (uint8) (MAGIC_C);
    digest[3] = (uint8) (MAGIC_D);

    digest[0] += results[lid];

    md5_64 (pw, digest);

    uint4 res[8];

    res[0] = (uint4) (digest[0].s0, digest[1].s0, digest[2].s0, digest[3].s0);
    res[1] = (uint4) (digest[0].s1, digest[1].s1, digest[2].s1, digest[3].s1);
    res[2] = (uint4) (digest[0].s2, digest[1].s2, digest[2].s2, digest[3].s2);
    res[3] = (uint4) (digest[0].s3, digest[1].s3, digest[2].s3, digest[3].s3);
    res[4] = (uint4) (digest[0].s4, digest[1].s4, digest[2].s4, digest[3].s4);
    res[5] = (uint4) (digest[0].s5, digest[1].s5, digest[2].s5, digest[3].s5);
    res[6] = (uint4) (digest[0].s6, digest[1].s6, digest[2].s6, digest[3].s6);
    res[7] = (uint4) (digest[0].s7, digest[1].s7, digest[2].s7, digest[3].s7);

    if (any (search != res[0])) results[lid] = 1;
    if (any (search != res[1])) results[lid] = 1;
    if (any (search != res[2])) results[lid] = 1;
    if (any (search != res[3])) results[lid] = 1;
    if (any (search != res[4])) results[lid] = 1;
    if (any (search != res[5])) results[lid] = 1;
    if (any (search != res[6])) results[lid] = 1;
    if (any (search != res[7])) results[lid] = 1;
  }
}
